<?php
/* --------------------------------------------------------------
 ConfigurationService.php 2020-03-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Services;

use Gambio\Core\Configuration\ConfigurationService as ServiceInterface;
use Gambio\Core\Configuration\Models\Read;
use Gambio\Core\Configuration\Models\Write;
use Gambio\Core\Configuration\Repositories\ConfigurationRepository;

/**
 * Class ConfigurationService
 * @package Gambio\Core\Configuration\ServicesF
 */
class ConfigurationService implements ServiceInterface
{
    /**
     * @var ConfigurationRepository
     */
    private $configurationRepository;
    
    
    /**
     * ConfigurationService constructor.
     *
     * @param ConfigurationRepository $configurationRepository
     */
    public function __construct(ConfigurationRepository $configurationRepository)
    {
        $this->configurationRepository = $configurationRepository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function findWithLanguageCode(string $key, string $languageCode): ?Read\Interfaces\Configuration
    {
        return $this->configurationRepository->findWithLanguageCode($key, $languageCode);
    }
    
    
    /**
     * @inheritDoc
     */
    public function findWithLanguageId(string $key, int $languageId): ?Read\Interfaces\Configuration
    {
        return $this->configurationRepository->findWithLanguageId($key, $languageId);
    }
    
    
    /**
     * @inheritDoc
     */
    public function find(string $key): ?Read\Interfaces\Configuration
    {
        return $this->configurationRepository->find($key);
    }
    
    
    /**
     * @inheritDoc
     */
    public function has(string $key): bool
    {
        return $this->configurationRepository->has($key);
    }
    
    
    /**
     * @inheritDoc
     */
    public function save(Write\Interfaces\Configuration ...$configurations): void
    {
        foreach ($configurations as $configuration) {
            if ($this->configurationRepository->has($configuration->key())) {
                $this->configurationRepository->update($configuration);
            } else {
                $this->configurationRepository->add($configuration);
            }
        }
    }
    
    
    /**
     * @inheritDoc
     */
    public function delete(string ...$keys): void
    {
        $this->configurationRepository->delete(...$keys);
    }
}